//
//  GSPipControllerManager.h
//  PIPDemo
//
//  Created by 230222 on 2025/11/14.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
@protocol GSPipControllerManagerDelegate <NSObject>
- (void)pipControllerDidStart;
- (void)pipControllerDidStop;
@end
NS_ASSUME_NONNULL_BEGIN
@interface GSPipControllerManager : NSObject
- (instancetype)initWith:(UIView *)playerView;
- (void)resetPlaceholderCIImage:(CIImage *)placeholderCIImage;
- (void)startPip;
- (void)stopPip;
@property (nonatomic, weak) id<GSPipControllerManagerDelegate> delegate;
- (void)setPlayerLayerFrame:(CGRect)frame;
@end

NS_ASSUME_NONNULL_END
